﻿########################################################### 
# AUTHOR      : Lukas Raunheimer, nexcon-it GmbH
#             : Patrick Schmidt, support@server-eye.de 
#               (Kleine Anpassung vorgenommen, Argument für Requester hinzugefügt)
# DESCRIPTION : Starts all deactivated exchange components
#   
# Use this script on your own risk!
########################################################### 


[CmdletBinding()]
Param (

       [AllowEmptyString()]
       [string]
       $requester = "HealthAPI"
)

$LogFile = "C:\Logs\Activate-ExchangeComponents.log"

Write-Host "Prüfe auf Existenz von C:\Logs"

If (!(Test-Path -Path C:\Logs)) {

    New-Item -Path "C:\" -Name "Logs" -ItemType Directory | Out-Null
    New-Item -Path C:\Logs\Activate-ExchangeComponents.log -ItemType File | Out-Null
    Write-Host "C:\Logs erstellt"
    Write-Host "C:\Logs\Activate-ExchangeComponents.log erstellt"

} else {

    If(!(Test-Path -Path C:\Logs\Activate-ExchangeComponents.log)) {

        New-Item -Path C:\Logs\Activate-ExchangeComponents.log -ItemType File | Out-Null
        Write-Host "C:\Logs\Activate-ExchangeComponents.log erstellt"

    } else {

        Write-Host "C:\Logs\Activate-ExchangeComponents.logs existierte bereits"

    }

    Write-Host "C:\Logs existierte bereits"

}

$Now = Get-Date 

Write-Host ""
Write-Host ""

Write-Host "Ausführungszeit: $Now" -ForegroundColor Yellow
"Ausführungszeit: $Now" | Out-File $LogFile -Append

$InactiveComponents = @()
$InactiveComponents += Get-ServerComponentState -Identity $env:COMPUTERNAME | Where-Object {$_.State -eq "Inactive"} | Select-Object -Property Component,Requester

If ($InactiveComponents.Count -ne 0) {
    $KomponentenMenge = $InactiveComponents.Count

    Write-Host "--------------------------------" -ForegroundColor Red
    Write-Host "Gefundene, inaktive Komponenten:" -ForegroundColor Red
    Write-Host "--------------------------------" -ForegroundColor Red
    "Gefundene, inaktive Komponenten:" | Out-File $LogFile -Append
    $InactiveComponents.Foreach{Write-Host $_.Component   -ForegroundColor Red}
    $InactiveComponents.Foreach{$_.Component | Out-File $LogFile -Append}
    Write-Host ""

    If ((Read-Host "Soll fortgefahren werden? Bitte mit Ja bestätigen") -eq "Ja") {
    
        Write-Host "Beginne Aktivierung"
        "Beginne Aktivierung" | Out-File $LogFile -Append

        ForEach ($Component in $InactiveComponents) {
           Write-Host "Aktiviere Komponente $Component.Component" 
            "Aktiviere Komponente $Component.Component" | Out-File $LogFile -Append
           Set-ServerComponentState -Identity $env:COMPUTERNAME -Component $Component.Component -Requester $requester -State Active
        }

        Write-Host "Es wurden $KomponentenMenge Komponenten aktiviert." 
        "Es wurden $KomponentenMenge Komponenten aktiviert." | Out-File $LogFile -Append

    } else { 

     Write-Host "OK, breche ab."
     "OK, breche ab." | Out-File $LogFile -Append

    }

} else {

    Write-Host "------------------------------------" -ForegroundColor Green
    Write-Host "Keine inaktiven Komponenten gefunden" -ForegroundColor Green
    Write-Host "------------------------------------" -ForegroundColor Green
    "Keine inaktiven Komponenten gefunden" | Out-File $LogFile -Append

}
