﻿########################################################### 
# AUTHOR      : Patrick Schmidt  
# DATE        : 16-12-2015   
# DESCRIPTION : This scripts checks if the decrypt virus is found in a specific location
#   
# VERSION     : 1.0
########################################################### 



param(
  [string] $path
)




$searchString1 = ".crypt"
$searchString2 = "decrypt.txt,decrypt.html"

Write-Host "Starting the check.. This can take a while (regarding the size of the given folder)"

$files = @([System.IO.Directory]::GetFiles($path,"*.*",[System.IO.SearchOption]::AllDirectories) | where { $searchString1 -contains  [System.IO.Path]::GetExtension($_) -OR $searchString2 -contains [System.IO.Path]::GetFileName($_)})

if($files.Length -gt 0){
    Write-Host "ERROR: Found files with the given signature!!" -BackgroundColor Red

    foreach($file in $files){
        Write-Host "File: $file"
    }
 exit -1
}else{
 Write-Host "OK: No files found with the given signature!!" -BackgroundColor Green
 exit 0
}

