﻿

[CmdletBinding()]
Param (
       [string]
       $Path,
       
       [AllowEmptyString()]
       [string[]]
       $Extensions = ".crypt",
       
       [AllowEmptyString()]
       [string[]]
       $Files = @("decrypt.txt", "decrypt.html"),
       
       [string]
       $LogPath = "$($env:USERPROFILE)\Desktop\DecryptList.log"
)
 
Write-Host "Starting the check.. This can take a while (regarding the size of the given folder)"
 
$result = @(Get-ChildItem -Path $Path -Recurse -Force | Where-Object { (-not $_.PSIsContainer) -and ($Extensions -contains [System.IO.Path]::GetExtension($_) -or ($Files -contains $_.Name)) })
 
if ($result.Length -gt 0)
{
       Write-Host "ERROR: Found files with the given signature!!" -BackgroundColor Red
       
       $result | Select-Object -ExpandProperty FullName | Out-File $LogPath
       
       $text = @"
Files found:
$(($result | Select-Object -ExpandProperty FullName) -join "`n")
       
Results were logged to: $LogPath
"@
       Write-Host $text
       exit -1
}
else
{
       Write-Host "OK: No files found with the given signature!!" -BackgroundColor Green
       exit 0
}


