﻿########################################################### 
# AUTHOR      : Patrick Schmidt, support@server-eye.de  
# DATE        : 30-11-2014   
# DESCRIPTION : This scripts deletes all files in an given folder (that are older than a specific amount of days)
#               (recursive mode is enabled)
#               Usage at your own risk!
# VERSION     : 1.1
########################################################### 
 
 
 $daysToDelete = 31
 $LogFolder = "C:\MyLogFolderIWantToDelete\My path can contain whitespaces"


 try{
    #PsIsContainer means if it is a folder..and compare to the lastWriteTime tresh we have given above..
    $itemsFound = Get-ChildItem $LogFolder -Recurse  | where{!$_.PsIsContainer -and $_.LastWriteTime -lt (Get-Date).AddDays(-$daysToDelete)}

    foreach($item in $itemsFound){
        $name = $item.Name
        $fullPath = $item.FullName
        $date = $item.LastWriteTime

        Write-Host "Delete item $name at path $fullpath , Last write time was  $date" 
        Remove-Item $fullPath -Force
    }

    #delete empty folders that are left behind now..
    Get-ChildItem -Path $LogFolder -Recurse -Force | Where-Object { $_.PSIsContainer -and (Get-ChildItem -Path $_.FullName -Recurse -Force | Where-Object { !$_.PSIsContainer }) -eq $null } | Remove-Item -Force -Recurse
  }Catch{ 
    Write-Warning "There seems to be a problem..."
    exit 2
 }

 #everything is fine..
 exit 0




