﻿########################################################### 
# AUTHOR      : Patrick Schmidt, support@server-eye.de  
# DATE        : 30-11-2014   
# DESCRIPTION : This scripts deletes all files in an given folder (that are older than a specific amount of days)
#               (recursive mode is enabled)
#               Usage at your own risk!
# VERSION     : 1.1
########################################################### 
 
<#
<description>Überwacht ein Logverzeichnis auf alte Dateien.</description>
<version>2</version>
#>

##parameters can be used inside of Server-Eye
param(
    [string]$path,
    [int]$days
)
 
 #not necessary but to keep the structure of the script in comparism to the simple one
 $daysToDelete = $days
 $LogFolder = $path


 #load the libraries from the Server Eye directory
$scriptDir = $MyInvocation.MyCommand.Definition |Split-Path -Parent |Split-Path -Parent

$pathToApi = $scriptDir + "\PowerShellAPI.dll"
$pathToJson = $scriptDir + "\Newtonsoft.Json.dll"
[Reflection.Assembly]::LoadFrom($pathToApi)
[Reflection.Assembly]::LoadFrom($pathToJson)

$api = new-Object ServerEye.PowerShellAPI
$msg = new-object System.Text.StringBuilder

$exitCode = 0

try{
    #PsIsContainer means if it is a folder..and compare to the lastWriteTime tresh we have given above..
    $itemsFound = Get-ChildItem $LogFolder -Recurse  | where{!$_.PsIsContainer -and $_.LastWriteTime -lt (Get-Date).AddDays(-$daysToDelete)}

    $counter = 0
    $itemsCount = $itemsFound.Length

    if($itemsCount -isnot [system.array]){
     $msg.AppendLine("Found $itemsCount files to delete")
    }else{
        $msg.AppendLine("Found 1 file to delete")
    }
    


    foreach($item in $itemsFound){
        $name = $item.Name
        $fullPath = $item.FullName
        $date = $item.LastWriteTime

        ##we only print out in the sensor output the first 20 files (otherwise it would be unreadable)
        if($counter -lt 20){

            $msg.AppendLine("Delete item $name at path $fullpath , Last write time was  $date")
        }

        Remove-Item $fullPath -Force

        $counter++
    }

    $msg.AppendLine("")
    $msg.AppendLine("$counter files actually deleted")
    $api.setMeasurementValue("Files deleted",[double]$counter)

    #delete empty folders that are left behind now..
    Get-ChildItem -Path $LogFolder -Recurse -Force | Where-Object { $_.PSIsContainer -and (Get-ChildItem -Path $_.FullName -Recurse -Force | Where-Object { !$_.PSIsContainer }) -eq $null } | Remove-Item -Force -Recurse
  }Catch{ 
    $msg.AppendLine("There seems to be a problem...")
    $api.setStatus([ServerEye.PowerShellStatus]::ERROR)
  }

 #everything is fine..

 if($exitCode -eq 0){
    $api.setStatus([ServerEye.PowerShellStatus]::OK)
 }

 <#api adding #> 
$api.setMessage($msg)  

#write our api stuff to the console. 
Write-Host $api.toJson() 
exit $exitCode




